{smcl}
{* *! version 1.0.0 4aug2014}{...}
{title:Title}

{phang}
{bf:svarih bacchiocchi {hline 2}} Heteroskedasticity-identified SVAR models, Bacchiocchi (2011) methodology


{marker syntax}{...}
{title:Syntax}

{p 12 27 2}
{cmd:svarih {ul:bac}chiocchi}
{depvarlist}
{ifin}
{cmd:,}
{opt rgmv:ar(rgmvarname)}
{opt rgmm:at(rgmmatname)}
[{it:optional_options}]{p_end}

{synoptset 37 tabbed}{...}
{marker options}{...}
{synopthdr:options}
{synoptline}
{syntab:Model: IH part}
{synopt:{opt rgmv:ar(rgmvarname)}}identify regimes by contents of variable {it:rgmvarname}{p_end}
{synopt:{opt rgmm:at(rgmmatname)}}indicate through matrix {it:rgmmatname} which variables are volatile during each regime{p_end}
{synopt:{opt acon:straints(constraints_a)}}apply previously defined {it:constraints_a} to {bf:A}{p_end}
{synopt:{opt ae:q(matrix_aeq)}}define and apply to {bf:A} equality constraint matrix {it:matrix_aeq}{p_end}
{synopt:{opt ac:ns(matrix_acns)}}define and apply to {bf:A} cross-parameter constraint matrix {it:matrix_acns}{p_end}
{synopt:{opt bcon:straints(constraints_b)}}apply previously defined {it:constraints_b} to {bf:B}{p_end}
{synopt:{opt be:q(matrix_beq)}}define and apply to {bf:B} equality constraint matrix {it:matrix_beq}{p_end}
{synopt:{opt bc:ns(matrix_bcns)}}define and apply to {bf:B} cross-parameter constraint matrix {it:matrix_bcns}{p_end}
{synopt:{opt econ:straints(constraints_e)}}apply previously defined {it:constraints_e} to {bf:E}{p_end}
{synopt:{opt ee:q(matrix_eeq)}}define and apply to {bf:E} equality constraint matrix {it:matrix_eeq}{p_end}
{synopt:{opt ec:ns(matrix_ecns)}}define and apply to {bf:E} cross-parameter constraint matrix {it:matrix_ecns}{p_end}
{synopt:{opt noiden:check}}do not check for local identification{p_end}
{synopt:{opt idend:etail}}display details of identification check if it fails{p_end}

{syntab:Model: VAR part}
{synopt:{opth la:gs(numlist)}}use lags {it:numlist} in the underlying VAR{p_end}
{synopt:{opth ex:og(varlist:varlist_exog)}}use exogenous variables {it:varlist_exog}{p_end}
{synopt:{opt nocons:tant}}suppress constant term{p_end}
{synopt:{opt dfk}}make small-sample degrees-of-freedom adjustment{p_end}
{synopt:{opt sm:all}}report small-sample t and F statistics{p_end}

{syntab:Reporting and screen output}
{synopt:{opt l:evel(#)}}set confidence level{p_end}
{synopt:{opt var}}display underlying {opt var} output{p_end}
{synopt:{opt nocnsr:eport}}do not display constraints{p_end}
{synopt:{opt not:able}}do not display estimation results table{p_end}
{synopt:{it:{help svarih_bac##display_options:display_options}}}control column formats{p_end}

{syntab:Maximization}
{synopt:{opt evalm:ode(modenum)}}choose between d0, d1, and d2 evaluators; rarely used{p_end}
{synopt:{opt glsi:ter(glsiternum)}}perform a maximum number of {it:glsiternum} GLS iterations; default: 0{p_end}
{synopt:{opt stol:erance(#)}}convergence criterion for GLS iteration on regime-specific residual covariance matrices{p_end}
{synopt:{opt btol:erance(#)}}convergence criterion for GLS iteration on ML coefficient vector{p_end}
{synopt:{opt glstr:ace}}display output of GLS iterations{p_end}
{synopt:{opt fixedfrom}}always use the same starting values for ML optimizations within the GLS iteration{p_end}
{synopt:{it:{help svarih_bac##maximize_options:maximize_options}}}control the maximization process{p_end}

{synopt :{opt coefl:egend}}display legend instead of statistics{p_end}
{synoptline}

{p 4 6 2}You must {cmd:tsset} your data before using {opt svarih bacchiocchi}; see {helpb tsset:[TS] tsset}. {p_end}
{p 4 6 2}{it:varlist_exog} may contain time-series operators; see {help tsvarlist}.{p_end}
{p 4 6 2}{it:depvarlist} may NOT contain time-series operators.{p_end}
{p 4 6 2}See {help svarih_postestimation:svarih postestimation} for features available after estimation.{p_end}


{marker description}{...}
{title:Description}

{pstd}
{cmd:svarih bacchiocchi} provides an alternative identification scheme for structural VARs than those implemented in {help svar}.
It implements a slightly generalized version of the "Identification through Heteroskedasticity" (IH) method as put forth in {help svarih_bac##B2011:Bacchiocchi (2011)}.
For details of the model setup, see the {help svarih_bac##remarks:Remarks} section.
For general information on IH methods and for other IH methods that are available, see {help svarih}.


{marker abbreviations}{...}
{title:Abbreviations, definitions, notation}

{pstd}
This help entry uses abbreviations and definitions from {help svarih##abbreviations:svarih}.


{marker options}{...}
{title:Options}

{dlgtab:Model: IH part}

{phang}
{opt rgmv:ar(rgmvarname)} determines the variable whose observations identify the volatility regimes.
It must be a numeric variable holding non-negative integer values where each integer value identifies a particular volatility regime.

{pmore}
It is not a requirement that a particular regime be contiguous.

{pmore}
A practical encoding is to define a baseline period to occur when {it:rgmvarname} is equal to one, and to encode each regime of different volatility by other non-negative integers.

{phang}
{opt rgmm:at(rgmmatname)} specifies an existing ({it:sbar x n+1}) matrix that contains information about the set of shocks that are volatile during a particular volatility regime.
The first column must contain non-negative integers.
No value may occur more than once.
Sorting these values ascendingly may be useful but is not a requirement.
Each element of the first column links its matrix row to observations of the estimation sample during which the level of {it:rgmvarname} is equal to the value of the element.
Columns 2 through {it:n}+1 correspond to the {it:n} endogenous variables of the system.
These columns may only have elements equal to zero or one.
A one indicates that the shock that corresponds to a particular column is volatile.

{pmore}
If this sounds confusing, have a look at the {help svarih_bac##examples:examples} section which illustrates the concepts involved with a simple example.

{pmore}
There are some more requirements that {it:rgmmatname} must fulfill:
The matrix column names must be equal to the string "rgmcode" followed by the variable names of the {it:n} endogenous variables, where the endogenous variables must be in the same order as in {depvarlist}.

{pmore}
As mentioned, the first column of the regime matrix contains entries that correspond to the regime encoding used by the regime variable.
Each level that the regime variable takes on in the estimation sample must be matched by a corresponding entry in the first column of the regime matrix.
Otherwise the command would not know which shocks are volatile during these periods.

{pmore}
The reverse is not true:
The first column of the regime matrix may contain entries that are not matched by levels of the regime variable within the estimation sample.
That way you are able to generate general regime matrices and use them in different contexts.
For example, suppose you have a 5-equation system, i.e. 5 shocks (referred to through the dependent variable of their equation).
Then the maximum number of regimes is 2^5=32.
You can create a regime matrix with 32 rows that covers each possible state.
Columns 2 through {it:n}+1 of each row of this matrix identify the volatile shocks in that state.
You can now use this particular encoding with different data sets, estimation samples, regime variables, etc. and always use this regime encoding, regardless of which regimes actually occur in the regime variable.

{pmore}
The actual regime matrix that is used by {cmd:svarih bacchiocchi} will be returned as e(rgmmat_used).
It is equal to {it:rgmmatname}, with rows irrelevant for estimation removed.
For example, if the regime variable has numerical encodings 1 and 2 in the estimation sample but the regime matrix lists three rows corresponding to encodings 1, 2, 5, the row corresponding to encoding 5 will not be contained in e(rgmmat_used).

{pmore}
Columns in e(rgmmat_used) that consist of zeroes only imply that the corresponding shock is never modeled to be volatile which implies zero constraints on the E-matrix for corresponding columns.
If these constraints are not specified in options {opt econstraints}, {opt eeq}, or {opt ecns}, the command will automatically generate the appropriate constraints on E for estimation.

{phang}
{opt acon:straints(constraints_a)}, {opt ae:q(matrix_aeq)}, {opt ac:ns(matrix_acns)} have the same meaning and can be specified in a similar manner as {opt aconstraints}, {opt aeq}, {opt acns} in {cmd:svar}.
See the exposition {help svar:there}.
They define linear constraints on the contemporaneous coefficients.
A difference to {cmd:svar} is that {opt acon:straints()} does accept restrictions across model matrices A, B, E.

{pmore}
{opt ae:q(matrix_aeq)} defines equality constraints.
{it:matrix_aeq} usually is an existing matrix but it may also be an expression as in {help matrix input} or a simple matrix function.
For example, {cmd:aeq((.,0\.,.))} and {cmd:aeq(I(2))} are allowed

{pmore}
{opt ac:ns(matrix_acns)} defines cross-equation constraints.
Argument {it:matrix_acns} can be supplied in the same way as {it:matrix_aeq} from option {opt aeq()}.

{pmore}
{opt acon:straints(constraints_a)} can define either one.
They are defined using the {help constraint} command.

{phang}
{opt bcon:straints(constraints_b)}, {opt be:q(matrix_beq)}, {opt bc:ns(matrix_bcns)} work in the same way as {opt aconstraints}, {opt aeq} and {opt acns}.
They define linear constraints on the regular shock transmission matrix B.

{phang}
{opt econ:straints(constraints_e)}, {opt ee:q(matrix_eeq)}, {opt ec:ns(matrix_ecns)} work in the same way as {opt aconstraints}, {opt aeq} and {opt acns}.
They define linear constraints on the shock impact modification matrix E.

{pmore}
If your regime matrix contains columns that consist of ones only, the elements of the corresponding column in E are automatically constrained to equal zero.

{phang}
{opt noiden:check} skips the check for local identification of parameters.
The check consists of examining the rank of a matrix at the parameter estimates.
Full rank of this matrix is needed for identification.
For details, see the associated PDF document on methods and formulas to {cmd:svarih}.

{phang}
{opt idend:etail} displays additional information on the identification check if it fails.
The identification check computes the rank of a matrix at the parameter estimates.
Full rank is required for local identification.
{opt idend:etail} displays rank information on submatrices also.
This may aide in finding new estimation specifications that pass the identification check.
For details, see the associated PDF document on methods and formulas to {cmd:svarih}.

{pmore}
If option {opt noidencheck} is used, option {opt idend:etail} is ignored.

{dlgtab:Model: VAR part}

{phang}
{opt la:gs(numlist)} see {help var} / {help svar}.

{phang}
{opth "exog(varlist:varlist_exog)"} see {help var} / {help svar}.

{phang}
{opt nocons:tant}; see
{bf:{help estimation options##noconstant:[R] estimation options}}.

{phang}
{opt dfk} see {help var} / {help svar}.

{phang}
{opt sm:all} see {help var} / {help svar}.

{dlgtab:Reporting and screen output}

{phang}
{opt l:evel(#)}; see
{bf:{help estimation options##level():[R] estimation options}}.

{phang}
{opt var} specifies that the output from {opt var} also be displayed.
By default, the underlying VAR is fit {helpb quietly}.
This option is not available when you replay estimates.

{phang}
{opt nocnsr:eport}; see {helpb estimation options##nocnsreport:[R] estimation options}.

{phang}
{opt not:able} does not display the estimation output table.
This is useful for example if you just want to look at the constraints that have been applied when obtaining {cmd:svarih} results.
Replaying results automatically reports these constraints.
You suppress most other output by

{phang2}
{cmd:. svarih, notable}

{marker display_options}{...}
{phang}
{it:display_options}: {opth cformat(%fmt)}, {opt pformat(%fmt)}, and {opt sformat(%fmt)};
see {helpb estimation options##display_options:[R] estimation options}.

{dlgtab:Maximization}

{phang}
{opt evalm:ode(modenum)} will choose between d0, d1, and d2 evaluators.
Rarely used.
The default is 2.
Can be used to check the numerical robustness of large models.

{phang}
{opt glsi:ter(glsiternum)} determines the maximum number of GLS iterations.
Note that the default is 0, i.e. no GLS iterations at all.

{phang}
The following options are relevant only if {opt glsiter(glsiternum)}, {it:glsiternum}>0 is specified:

{phang2}
    {opt stol:erance(#)} and {opt btol:erance(#)} are two criteria that must be both fulfilled for GLS convergence to be declared.

{phang3}{...}
        {opt stol:erance(#)} calculates a matrix relative difference of the regime-specific reduced-form covariance matrices of the current iteration to the ones from the previous iteration.
        This criterion is fulfilled if the matrix relative difference is less than {cmd:#}.
        The default for {cmd:#} is 1e-4.

{phang3}{...}
        {opt btol:erance(#)} calculates a matrix relative difference of the estimated ML coefficient vector of the current iteration to the one from the previous iteration.
        This criterion is fulfilled if the matrix relative difference is less than {cmd:#}.
        The default for {cmd:#} is 1e-4.

{phang2}
    {opt glstr:ace} outputs the following during each GLS iteration: the estimated coefficient vector, the regime-specific reduced-form covariance matrices, and the ML optimization of the current GLS iteration.

{phang2}
    {opt fixedfrom} specifies that the same starting values are used for the ML optimization in each GLS iteration.
    By default, the ML estimates from the previous iteration are used as starting values for the current ML optimization.

{marker maximize_options}{...}
{phang}
{it:maximize_options}:
{opt dif:ficult},
{opth tech:nique(maximize##algorithm_spec:algorithm_spec)},
{opt iter:ate(#)},
[{cmdab:no:}]{opt lo:g},
{opt tr:ace},
{opt grad:ient},
{opt showstep},
{opt hess:ian},
{opt showtol:erance},
{opt tol:erance(#)},
{opt ltol:erance(#)},
{opt nrtol:erance(#)},
{opt nonrtol:erance(#)}, and
{opt from(init_specs)};
see {manhelp maximize R}.

{phang}
{opt coeflegend}; see {helpb estimation options##coeflegend:[R] estimation options}.


{marker remarks}{...}
{title:Remarks}

{pstd}
Remarks are presented under the following headings:

    {help svarih_bac##modelequations:Model equations}
    {help svarih_bac##glsiteration:GLS iteration to achive ML estimates}

{marker modelequations}{...}
{title:Model equations}

{pstd}
The IH-BAC method consists of an extended maximum likelihood structural VAR framework.
The extension consists of positing a priori knowledge about different regimes of volatility, i.e. time periods during which the structural shocks have different variances and possibly nonzero covariances.
Consequently, a prerequisite for estimation is the specification of a variable that identifies these regimes.
In addition, to complete the information necessary for running the command, a matrix must be supplied that specifies for each volatility state the variables that are volatile.
In the following, these two components are referred to as the "regime variable" and the "regime matrix".

{pstd}
In terms of a typical structural VAR equation that relates VAR residuals u_t to structural shocks e_t, the model in Baccchiocchi (2011) reads

{p 40 40}
(1)   A*u_t = (I + B*D_s)*e_t

{pstd}
The matrix A models the contemporaneous effects among the endogenous variables, I is the identity matrix, B models the contemporaneous impact of shocks, and D_s is a diagonal regime-specific selection matrix that switches columns of B on and off.
The generalized version of this equation implemented in {cmd:svarih bacchiocchi} reads

{p 40 40}
(2)   A*u_t = (B + E*D_s)*e_t

{pstd}
where the identity matrix I has now been replaced by a potentially unrestricted matrix of coefficients B and the E-matrix in (2) corresponds to the B-matrix in (1).
If D_s is the zero matrix, the model (2) collapses into the standard SVAR model implemented in {help svar}.

{marker glsiteration}{...}
{title:GLS iteration to achieve ML estimates}

{pstd}
The GLS iteration is done in an analogous fashion to the one in {cmd:svarih llutkepohl}.
See the {help svarih_llu##glsiteration:discussion} there.


{marker examples}{...}
{title:Examples}

{pstd}
The following example illustrates the mechanics of {cmd:svarih bac}.
It does not discuss the important issues of the interpretation of the shocks.
It focuses on the mechanics.
It builds on the example given in {cmd:svar} so you can compare the IH-BAC setup to the one of {cmd:svar}.

{pstd}
Throughout this example section, we store estimated results in Stata's estimation results catalogue for later access.
The utility {help svarih examples} allows you to easily re-generate these estimates at any point.

{pstd}
We first load the data set and define constraints.
Then we estimate an {cmd:svar} model that is similar to the one of the examples section of {cmd:[TS] svar}, except that we choose to not restrict the estimation sample here.

{phang2}{stata webuse lutkepohl2:. webuse lutkepohl2}{p_end}
{phang2}{stata matrix aeq = (1,0,0 \ .,1,0 \ .,.,1):. matrix aeq = (1,0,0 \ .,1,0 \ .,.,1)}{p_end}
{phang2}{stata matrix beq = (.,0,0 \ 0,.,0 \ 0,0,.):. matrix beq = (.,0,0 \ 0,.,0 \ 0,0,.)}{p_end}
{phang2}{stata svar dln_inv dln_inc dln_consump, aeq(aeq) beq(beq):. svar dln_inv dln_inc dln_consump, aeq(aeq) beq(beq)}{p_end}
{phang2}{stata est store bac_svar:. est store bac_svar}{p_end}

{pstd}
In order to move to IH-BAC, we first must define a regime variable and a corresponding regime matrix.
In order to illustrate the mechanics of {cmd:svarih bac}, we make the following assumptions:
We have prior knowledge that the volatilities of the shocks in our model have changed in the 1970s.
We fix a date of change of volatilities of 1974q1.
The following generates a regime variable that contains values of 1 and 2. While we could have coded regimes with any integers of our choosing,
this particular encoding will be useful when comparing estimation methods to {cmd:svarih bfa} and {cmd:svarih llu}, for which the regime encoding is hardcoded.

{phang2}{stata gen byte rgmvar = (qtr>=tq(1974q1)) + 1:. gen byte rgmvar = (qtr>=tq(1974q1)) + 1}{p_end}
{phang2}{stata matrix rgmmat = (1 , 0 , 0 , 0 \ 2 , 1 , 1 , 1 \ 3 , 1 , 0 , 1 ):. matrix rgmmat = (1 , 0 , 0 , 0 \ 2 , 1 , 1 , 1 \ 3 , 1 , 0 , 1 )}{p_end}
{phang2}{stata matrix colnames rgmmat = rgmcode dln_inv dln_inc dln_consump:. matrix colnames rgmmat = rgmcode dln_inv dln_inc dln_consump}{p_end}
{phang2}{stata matrix list rgmmat:. matrix list rgmmat}{p_end}

{pstd}
It is worth reiterating that the occurence of regimes can be modeled to be much more complicated than this.
Any sequence and any multiplicity of regimes, with any occurence of gaps in the data, are allowed.
If there are enough observations, {cmd:svarih bac} will produce estimates.

{pstd}
The regime matrix contains a regime encoding "3" which does not occur in the sample.
This is no problem, and this line is merely included in the matrix to make this point.
{cmd:svarih bac} would not allow this the other way round: All levels of the regime variable that occur in the sample must have an entry in the regime matrix.
Lastly, we have to decide which constraints we impose on the shock modification matrix E.
In the current setup, it makes sense to define analogous constraints to those of B.

{phang2}{stata matrix eeq = (.,0,0 \ 0,.,0 \ 0,0,.):. matrix eeq = (.,0,0 \ 0,.,0 \ 0,0,.)}{p_end}
{phang2}{stata svarih bac dln_inv dln_inc dln_consump , rgmvar(rgmvar) rgmmat(rgmmat) aeq(aeq) beq(beq) eeq(eeq):. svarih bac dln_inv dln_inc dln_consump , rgmvar(rgmvar) rgmmat(rgmmat) aeq(aeq) beq(beq) eeq(eeq)}{p_end}
{phang2}{stata est store bac_first:. est store bac_first}{p_end}

{pstd}
Estimation replay can be done in the standard way:

{phang2}{stata svarih:. svarih}{p_end}

{pstd}
but there exists a convenient postestimation option {opt cmat} that changes replay behavior. See {help svarih cmat}.
Option {opt star} encodes significance levels 0.01, 0.05, 0.1 by .a, .b, .c.

{phang2}{stata svarih , cmat format(%12.3f) star:. svarih , cmat format(%12.3f) star}{p_end}

{pstd}
According to our model, the volatility of the shock of the first equation is significantly  lower after 1974.

{pstd}
A major advantage of IH methods is that they can be used to relax required constraints of standard SVAR models.
We further relax constraints on A, which is not possible in a standard SVAR model.
As a rule of thumb, the more variables are modeled to have changes in volatility, the less constraints you have to impose on A, B, and E.
In the following, we constrain the insignificant elements of E to zero.
As an alternative to that, we could have redefined the regime matrix so that only the shock of the first equation is volatile in regime 2.

{pstd}
In order to obtain proper ML estimates, we explicitly specify the option {opt glsiter()}.

{phang2}{stata matrix aeq = (1,.,. \ .,1,0 \ .,.,1):. matrix aeq = (1,.,. \ .,1,0 \ .,.,1)}{p_end}
{phang2}{stata matrix eeq = (.,0,0 \ 0,0,0 \ 0,0,0):. matrix eeq = (.,0,0 \ 0,0,0 \ 0,0,0)}{p_end}
{phang2}{stata svarih bac dln_inv dln_inc dln_consump , rgmvar(rgmvar) rgmmat(rgmmat) aeq(aeq) beq(beq) eeq(eeq) glsiter(100):. svarih bac dln_inv dln_inc dln_consump , rgmvar(rgmvar) rgmmat(rgmmat) aeq(aeq) beq(beq) eeq(eeq) glsiter(100)}{p_end}
{phang2}{stata est store bac_unconstr_gls:. est store bac_unconstr_gls}{p_end}
{phang2}{stata svarih , cmat format(%12.3f) star:. svarih , cmat format(%12.3f) star}{p_end}

{pstd}
The estimation output informs us that parameters are locally identified.
If we relax the exclusion retriction of element [2,3] of A, this is no longer the case.
Below we suppress most of the output.

{phang2}{stata matrix aeq = (1,.,. \ .,1,. \ .,.,1):. matrix aeq = (1,.,. \ .,1,. \ .,.,1)}{p_end}
{phang2}{stata svarih bac dln_inv dln_inc dln_con, rgmv(rgmvar) rgmm(rgmmat) aeq(aeq) beq(beq) eeq(eeq) glsi(100) not nocnsr:. svarih bac dln_inv dln_inc dln_con, rgmv(rgmvar) rgmm(rgmmat) aeq(aeq) beq(beq) eeq(eeq) glsi(100) not nocnsr}{p_end}
{phang2}{stata est store bac_notident:. est store bac_notident}{p_end}

{pstd}
Going back to the identified model, we can perform LR-tests on model adequacy.
We do this for the model with A-constraints as in {cmd:svar} and the one that relaxes the constraints on the first equation.
We first need to estimate the constrained model.

{phang2}{stata matrix aeq = (1,0,0 \ .,1,0 \ .,.,1):. matrix aeq = (1,0,0 \ .,1,0 \ .,.,1)}{p_end}
{phang2}{stata svarih bac dln_inv dln_inc dln_con, rgmv(rgmvar) rgmm(rgmmat) aeq(aeq) beq(beq) eeq(eeq) glsi(100) not nocnsr:. svarih bac dln_inv dln_inc dln_con, rgmv(rgmvar) rgmm(rgmmat) aeq(aeq) beq(beq) eeq(eeq) glsi(100) not nocnsr}{p_end}
{phang2}{stata est store bac_constr_gls:. est store bac_constr_gls}{p_end}
{phang2}{stata lrtest bac_constr_gls bac_unconstr_gls , stat:. lrtest bac_constr_gls bac_unconstr_gls , stat}{p_end}

{pstd}
The LR-test rejects the constraints at the 1% level.

{pstd}
{cmd:predict} after {cmd:svarih bacchiocchi} generates prediced values, residuals, shocks, and historical decompositions.
{cmd:dsimih} generates dynamic simulation statistics.
For all features available after estimation, see {help svarih postestimation}.

{pstd}
As an aside, when constraining the E-matrix of the model to a null matrix, IH-BAC collapses to a standard SVAR model, and estimates coincide with those of {cmd:svar}.

{phang2}{stata matrix eeq = (0,0,0 \ 0,0,0 \ 0,0,0):. matrix eeq = (0,0,0 \ 0,0,0 \ 0,0,0)}{p_end}
{phang2}{stata qui svarih bac dln_inv dln_inc dln_consump , rgmvar(rgmvar) rgmmat(rgmmat) aeq(aeq) beq(beq) eeq(eeq):. qui svarih bac dln_inv dln_inc dln_consump , rgmvar(rgmvar) rgmmat(rgmmat) aeq(aeq) beq(beq) eeq(eeq)}{p_end}
{phang2}{stata est store bac_svarrepl:. est store bac_svarrepl}{p_end}
{phang2}{stata estimates table bac_svar bac_svarrepl , p:. estimates table bac_svar bac_svarrepl , p}{p_end}


{marker saved_results}{...}
{title:Saved results}

{pstd}
{cmd:svarih bacchiocchi} saves the following in {cmd:e()}:

{synoptset 20 tabbed}{...}
{p2col 5 20 24 2: Scalars}{p_end}
{synopt:{cmd:e(N)}}number of observations{p_end}
{synopt:{cmd:e(N_cns)}}number of independent constraints{p_end}
{synopt:{cmd:e(k_eq)}}number of equations in {cmd:e(b)}{p_end}
{synopt:{cmd:e(k_dv)}}number of dependent variables{p_end}
{synopt:{cmd:e(k_aux)}}number of auxiliary parameters{p_end}
{synopt:{cmd:e(ll)}}log likelihood{p_end}
{synopt:{cmd:e(N_gaps)}}number of gaps in the sample{p_end}
{synopt:{cmd:e(k_var)}}number of coefficients in VAR{p_end}
{synopt:{cmd:e(k_eq_var)}}number of equations in underlying VAR{p_end}
{synopt:{cmd:e(k_dv_var)}}number of dependent variables in underlying VAR{p_end}
{synopt:{cmd:e(df_eq_var)}}average number of parameters in an equation{p_end}
{synopt:{cmd:e(df_r_var)}}if {cmd:small}, VAR residual degrees of freedom{p_end}
{synopt:{cmd:e(mlag)}}highest lag in VAR{p_end}
{synopt:{cmd:e(tmin)}}first time period in the sample{p_end}
{synopt:{cmd:e(tmax)}}maximum time{p_end}
{synopt:{cmd:e(rank)}}rank of {cmd:e(V)}{p_end}
{synopt:{cmd:e(ic_ml)}}number of iterations in the final ML optimization{p_end}
{synopt:{cmd:e(rc_ml)}}return code from {cmd:ml}{p_end}
{synopt:{cmd:e(converged_ml)}}{cmd:1} if {cmd:ml} declared convergence, {cmd:0} otherwise{p_end}
{synopt:{cmd:e(converged_gls)}}{cmd:1} if the GLS iteration declared convergence, {cmd:0} otherwise{p_end}
{synopt:{cmd:e(ic_gls)}}number of GLS iterations performed{p_end}
{synopt:{cmd:e(glsiter)}}maximium # of GLS iterations allowed in command execution{p_end}
{synopt:{cmd:e(numregimes)}}number of regimes marked by {it:regimevar}{p_end}

{synoptset 20 tabbed}{...}
{p2col 5 20 24 2: Macros}{p_end}
{synopt:{cmd:e(cmd)}}{cmd:svarih}{p_end}
{synopt:{cmd:e(method)}}{cmd:Bacchiocchi}{p_end}
{synopt:{cmd:e(version)}}version number of command{p_end}
{synopt:{cmd:e(cmdline)}}command as typed{p_end}
{synopt:{cmd:e(lags)}}lags in model{p_end}
{synopt:{cmd:e(depvar)}}names of dependent variables{p_end}
{synopt:{cmd:e(rgmvar)}}name of variable that identifies regimes{p_end}
{synopt:{cmd:e(rgmmatname)}}name of regime matrix{p_end}
{synopt:{cmd:e(exog)}}names of exogenous variables, if specified{p_end}
{synopt:{cmd:e(nocons)}}noconstant, if {cmd:noconstant} specified{p_end}
{synopt:{cmd:e(cns_a)}}comprehensive list of constraints on A{p_end}
{synopt:{cmd:e(cns_b)}}comprehensive list of constraints on B{p_end}
{synopt:{cmd:e(cns_e)}}comprehensive list of constraints on E{p_end}
{synopt:{cmd:e(dfk_var)}}alternate divisor ({cmd:dfk}), if specified{p_end}
{synopt:{cmd:e(small)}}{cmd:small}, if specified{p_end}
{synopt:{cmd:e(tsfmt)}}format of timevar{p_end}
{synopt:{cmd:e(timevar)}}name of timevar{p_end}
{synopt:{cmd:e(title)}}title in estimation output{p_end}
{synopt:{cmd:e(predict)}}program used to implement {cmd:predict}{p_end}
{synopt:{cmd:e(from)}}contents of maximization option {opt from}, if specified as a string{p_end}
{synopt:{cmd:e(mlopts)}}maximization options used{p_end}
{synopt:{cmd:e(idencheck)}}result of identification check; one of {cmd:passed}, {cmd:failed}, or {cmd:skipped}{p_end}
{synopt:{cmd:e(regimes)}}regime encodings that occur in sample{p_end}
{synopt:{cmd:e(regimes_Ns)}}number of observations in each regime{p_end}
{synopt:{cmd:e(glsopts)}}GLS-related options supplied to command by user{p_end}

{synoptset 20 tabbed}{...}
{p2col 5 20 24 2: Matrices}{p_end}
{synopt:{cmd:e(b)}}coefficient vector{p_end}
{synopt:{cmd:e(Cns)}}constraints matrix{p_end}
{synopt:{cmd:e(Sigma)}}Residual covariance matrix of underlying VAR{p_end}
{synopt:{cmd:e(Sigma_rgm#)}}Residual covariance matrix for obs of regime #, based on the underlying GLS-VAR (if {opt glsiter(#)}, {it:#}>0) or of the underlying VAR{p_end}
{synopt:{cmd:e(V)}}variance-covariance matrix of the estimators{p_end}
{synopt:{cmd:e(b_var)}}coefficient vector of underlying VAR model{p_end}
{synopt:{cmd:e(V_var)}}VCE of underlying VAR model{p_end}
{synopt:{cmd:}}{p_end}
{synopt:{cmd:}}if GLS iteration was performed{p_end}
{synopt:{cmd:e(b_vargls)}}coefficient vector of underlying GLS-VAR model{p_end}
{synopt:{cmd:e(V_vargls)}}VCE of underlying GLS-VAR model{p_end}
{synopt:{cmd:}}{p_end}
{synopt:{cmd:e(aeq)}}{cmd:aeq(}{it:matrix}{cmd:)}, if specified{p_end}
{synopt:{cmd:e(acns)}}{cmd:acns(}{it:matrix}{cmd:)}, if specified{p_end}
{synopt:{cmd:e(beq)}}{cmd:beq(}{it:matrix}{cmd:)}, if specified{p_end}
{synopt:{cmd:e(bcns)}}{cmd:bcns(}{it:matrix}{cmd:)}, if specified{p_end}
{synopt:{cmd:e(eeq)}}{cmd:eeq(}{it:matrix}{cmd:)}, if specified{p_end}
{synopt:{cmd:e(ecns)}}{cmd:ecns(}{it:matrix}{cmd:)}, if specified{p_end}
{synopt:{cmd:e(A)}}estimated A matrix{p_end}
{synopt:{cmd:e(B)}}estimated B matrix{p_end}
{synopt:{cmd:e(E)}}estimated E matrix{p_end}
{synopt:{cmd:e(rgmmat)}}regime matrix as passed to the command{p_end}
{synopt:{cmd:e(rgmmat_used)}}equal to {it:rgmmatname}, with rows irrelevant for estimation removed{p_end}
{synopt:{cmd:e(from)}}matrix of maximization option {opt from}, if specified as a matrix{p_end}

{synoptset 20 tabbed}{...}
{p2col 5 20 24 2: Functions}{p_end}
{synopt:{cmd:e(sample)}}marks estimation sample{p_end}
{p2colreset}{...}


{marker author}{...}
{title:Author}

{phang}
Daniel C. Schneider, Goethe University Frankfurt, dan_schneider@outlook.com


{marker acknowledgements}{...}
{title:Acknowledgements}

{pstd}
The code of official Stata's {cmd:svar} has served as a point of reference throughout the development of {cmd:svarih bacchiocchi}.
Any remaining errors in {cmd:svarih bacchiocchi} are mine.


{marker references}{...}
{title:References}

{marker B2011}{...}
{phang}
Bacchiocchi, E. (2011): Identification in Structural VAR Models with Different Volatility Regimes.
Universita Degli Studi di Milano, Working Paper No.2011-39.{p_end}


{marker alsosee}{...}
{title:Also see}

{psee}
Help:
{helpb svar:[TS] svar},
{helpb svarih},
{helpb svarih bfa},
{helpb svarih llu},
{helpb svarih postestimation},
{helpb svarih cmat},
{helpb dsimih}
{p_end}

